package com.biz.crm.nebular.sfa.worksign.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作日调整列表 请求vo
 *
 * @author ren.gan
 * @date 2020-11-20 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkOvertimeListReqVo", description = "工作日调整列表 请求vo")
public class SfaWorkOvertimeListReqVo extends PageVo {

    @ApiModelProperty("人员帐号")
    private String userCode;

    @ApiModelProperty("人员姓名")
    private String userName;

    @ApiModelProperty("申请日期开始 (yyyy-MM-dd)")
    private String applicationDateStart;
    @ApiModelProperty("申请日期结束 (yyyy-MM-dd)")
    private String applicationDateEnd;

    @ApiModelProperty("工作日调整开始时间开始 (yyyy-MM-dd)")
    private String beginTimeStart;
    @ApiModelProperty("工作日调整开始时间结束 (yyyy-MM-dd)")
    private String beginTimeEnd;

    @ApiModelProperty("工作日调整结束时间开始 (yyyy-MM-dd)")
    private String endTimeStart;
    @ApiModelProperty("工作日调整结束时间结束 (yyyy-MM-dd)")
    private String endTimeEnd;

    @ApiModelProperty("审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态 多选")
    private List<String> bpmStatusList;


}