package com.biz.crm.nebular.sfa.worksign.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作日调整 请求vo
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkOvertimeReqVo", description = "工作日调整申请 Vo ")
public class SfaWorkOvertimeReqVo {

    @ApiModelProperty("主键id-修改用")
    private String id;

    @ApiModelProperty("请假事由 请假事由")
    private String overtimeReason;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("日期明细列表")
    private List<SfaApplyTimeInfoReqVo> timeInfoList;

    @ApiModelProperty("工作日调整时长(天)")
    private Float overtimeDuration;

}