package com.biz.crm.nebular.tpm.account.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 费用上账总出参;请求vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAccountDetailMainRespVo", description = "费用上账总出参;")
public class TpmAccountDetailMainRespVo {

    @ApiModelProperty("分组id(标识同一次提交的数据)")
    @SaturnColumn(description = "分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("费用上账数据")
    @SaturnColumn(description = "费用上账数据")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAccountDetailRespVo> accountDetailRespVos;

    @ApiModelProperty("费用上账发票数据")
    @SaturnColumn(description = "费用上账发票数据")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAccountInvoiceRespVo> accountInvoiceRespVos;

}