package com.biz.crm.nebular.tpm.auditcollectexample.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 核销采集示例主表 返回vo
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销采集示例主表 ")
@SaturnEntity(name = "TpmAuditCollectExampleRespVo", description = "核销采集示例主表 ")
public class TpmAuditCollectExampleRespVo extends CrmExtVo {
    @ApiModelProperty("示例编码")
    @SaturnColumn(description = "示例编码")
    private String exampleCode;

    @ApiModelProperty("示例名称")
    @SaturnColumn(description = "示例名称")
    private String exampleName;

    @ApiModelProperty("类型(数据字典)")
    @SaturnColumn(description = "类型")
    private String exampleType;

    @ApiModelProperty("类型名称")
    @SaturnColumn(description = "类型")
    private String exampleTypeName;

    @ApiModelProperty("排序")
    @SaturnColumn(description = "排序")
    private Integer sortNum;

    @ApiModelProperty("示例照片")
    @SaturnColumn(description = "示例照片")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditCollectExamplePictureRespVo> pictureRespVos;

    @ApiModelProperty("核销资料要求")
    @SaturnColumn(description = "核销资料要求")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditCollectExampleRespVo> auditRequires;

}