package com.biz.crm.nebular.tpm.costtypecategories.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 活动大类范围表;返回vo
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动大类范围表;")
@SaturnEntity(name = "TmpCostTypeCategoriesRangeRespVo", description = "活动大类范围表;")
public class TpmCostTypeCategoriesRangeRespVo extends CrmExtVo {
    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("范围类型(1,组织,2,组织类型)")
    @SaturnColumn(description = "范围类型(1,组织,2,组织类型)")
    private Integer rangeType;

    @ApiModelProperty("对应范围的编码")
    @SaturnColumn(description = "对应范围的编码")
    private String rangeCode;

    @ApiModelProperty("对应范围的名称")
    @SaturnColumn(description = "对应范围的名称")
    private String rangeName;

    @ApiModelProperty("是否包含(Y,包含,N不包含)")
    @SaturnColumn(description = "是否包含(Y,包含,N不包含)")
    private String isContain;

    @ApiModelProperty("是否仅当前组织(Y:当前组织,N:当前组织和下级组织)")
    @SaturnColumn(description = "是否仅当前组织(Y:当前组织,N:当前组织和下级组织)")
    private String isOnlyCurrent;


}