package com.biz.crm.nebular.tpm.costtypefine.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动采集字段表与活动细类的关联表;返回vo
 *
 * @author zeyi
 * @date 2020-11-04 13:59:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动采集字段表与活动细类的关联表;")
@SaturnEntity(name = "TpmActCollectFieldFineRespVo", description = "活动采集字段表与活动细类的关联表;")
public class TpmActCollectFieldFineRespVo extends CrmBaseVo {
    @ApiModelProperty("活动采集字段编码")
    @SaturnColumn(description = "活动采集字段编码")
    private String fieldCode;

    @ApiModelProperty("活动采集字段名称")
    private String fieldName;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("是否必填(Y/N)")
    @SaturnColumn(description = "是否必填(Y/N)")
    private String whetherRequired;

    @ApiModelProperty("显示顺序")
    @SaturnColumn(description = "显示顺序")
    private String displayOrder;

    @ApiModelProperty("默认值")
    @SaturnColumn(description = "默认值")
    private String defaults;

    @ApiModelProperty("提示语")
    @SaturnColumn(description = "提示语")
    private String hint;

}