package com.biz.crm.nebular.tpm.feebudget.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用预算管控维度表 返回vo
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用预算管控维度表 ")
@SaturnEntity(name = "TpmFeeBudgetControlRespVo", description = "费用预算管控维度表 ")
public class TpmFeeBudgetControlRespVo extends CrmExtVo {
    @ApiModelProperty("费用预算类型(字典)")
    @SaturnColumn(description = "费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("费用预算类型名称")
    @SaturnColumn(description = "费用预算类型名称")
    private String feeBudgetTypeName;

    @ApiModelProperty("搜索key")
    @SaturnColumn(description = "搜索key")
    private String selectKey;

    @ApiModelProperty("预算年份(字典)")
    @SaturnColumn(description = "预算年份(字典)")
    private String budgetYear;

    @ApiModelProperty("预算年份名称")
    @SaturnColumn(description = "预算年份")
    private String budgetYearName;

    @ApiModelProperty("预算季度(字典)")
    @SaturnColumn(description = "预算季度(字典)")
    private String budgetQuater;

    @ApiModelProperty("预算季度名称")
    @SaturnColumn(description = "预算季度")
    private String budgetQuaterName;

    @ApiModelProperty("预算月份(字典)")
    @SaturnColumn(description = "预算月份(字典)")
    private String budgetMonth;

    @ApiModelProperty("预算月份名称")
    @SaturnColumn(description = "预算月份")
    private String budgetMonthName;

    @ApiModelProperty("预算科目编码")
    @SaturnColumn(description = "预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    @SaturnColumn(description = "预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("组织类型")
    @SaturnColumn(description = "组织类型")
    private String orgType;

    @ApiModelProperty("组织类型名称")
    @SaturnColumn(description = "组织类型名称")
    private String orgTypeName;

    @ApiModelProperty("渠道(字典)")
    @SaturnColumn(description = "渠道(字典)")
    private String channel;

    @ApiModelProperty("渠道名称")
    @SaturnColumn(description = "渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("可用余额")
    @SaturnColumn(description = "可用余额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("费用预算集合")
    @SaturnColumn(description = "费用预算集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmFeeBudgetRespVo> feeBudgetVos;


}