package com.biz.crm.nebular.activiti.start.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "StartProcessReqVO", description = "移动端发起流程请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class StartProcessReqVO {

    @ApiModelProperty(value = "业务表单单号", required = true)
    private String formNo;

    @ApiModelProperty("发起人编码")
    private String userCode;

    @ApiModelProperty(value = "发起人岗位编码", required = true)
    private String positionCode;

    @ApiModelProperty(value = "表单类型", required = true)
    private String costType;

    @ApiModelProperty(value = "发起流程来源业务系统", required = true)
    private String formType;

    @ApiModelProperty(value = "表单url", required = true)
    private String formUrl;

    @ApiModelProperty(value = "标题", required = true)
    private String title;

    @ApiModelProperty("表单类型二级编码")
    private String smallType;

    @ApiModelProperty(value = "防重验证码", required = true)
    private String signTicket;

    @ApiModelProperty("关联单号，如果找到对应单号的流程实例，会自动关联")
    private List<String> parentFormNos;

    @ApiModelProperty("备注")
    private String remark;
}
