package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.CrmFileVo;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池条目调整明细VO
 * @Author: chenrong
 * @Date: 2020/11/23 16:53
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣费用池条目调整明细VO")
public class RebateFeePoolDetailLogVo extends CrmFileVo {

  private static final long serialVersionUID = -4941737089772063724L;

  /**
   * 折扣费用池条目编码
   */
  private String rebateFeePoolDetailCode;

  /**
   * 折扣费用池条目调整明细编码
   */
  private String code;

  /**
   * 调整类型
   */
  private Integer adjustType;

  /**
   * 业务来源编码
   */
  private String businessCode;

  /**
   * 调整金额
   */
  private BigDecimal adjustFee = BigDecimal.ZERO;

  /**
   * 支付方式
   */
  private Integer payType;

  /**
   * 备注
   */
  private String remark;
}
