package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户信息销售区域返回vo
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户信息销售区域")
@SaturnEntity(name = "MdmCustomerSaleAreaRespVo", description = "客户信息销售区域")
public class MdmCustomerSaleAreaRespVo extends CrmTreeTenVo {

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("一级区域")
    @SaturnColumn(description = "一级区域")
    private String areaOne;

    @ApiModelProperty("一级区域名称")
    @SaturnColumn(description = "一级区域名称")
    private String areaOneName;

    @ApiModelProperty("二级区域编码")
    @SaturnColumn(description = "二级区域编码")
    private String areaTwo;

    @ApiModelProperty("二级区域名称")
    @SaturnColumn(description = "二级区域名称")
    private String areaTwoName;

}