package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Set;

/**
 * 组织存储信息
 *
 * @author zxw
 * @date 2020-10-23 14:12
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel("组织存储信息")
@Deprecated
public class EngineOrgStoreVo {
    private String id;

    @SaturnColumn(description="组织机构的唯一编号", length=128, nullable=false,unique = true)
    private String code;
    @SaturnColumn(description = "组织机构名称", length = 64, nullable = false)
    private String orgName;
    @SaturnColumn(description = "组织机构类型(0:部门,1:单位)", nullable = false)
    private Integer type;
    @SaturnColumn(description = "组织机构描述", nullable = false, length = 512)
    private String description = "";
    @SaturnColumn(description = "组织机构排序", nullable = false)
    private Integer sortIndex = 100;
    @SaturnColumn(description = "创建时间", nullable = false)
    private Date createTime = new Date();
    @SaturnColumn(description = "组织机构绑定的岗位信息")
    
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany, mappedBy="organization")
    private Set<EnginePositionStoreVo> positions;

    @SaturnColumn(description = "子级组织")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany, master=true, mappedBy="orgs")
    private Set<EngineOrgStoreVo> child;

    private EngineOrgStoreVo parent;
    @SaturnColumn(description = "组织机构状态", nullable = false)
    private Integer tstatus;
    private Boolean isLeaf;
}
