package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
/**
 * 一个拥有权限信息的业务系统用户定义请求vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineUserReqVo", description = "一个拥有权限信息的业务系统用户定义")
@Deprecated
public class EngineUserReqVo extends CrmBaseVo {

    @ApiModelProperty("id集合")
    private List<String> ids;

    @ApiModelProperty("用户账号登录信息")
    private String userAccount;

    @ApiModelProperty("性别.0保密，1男 2女")
    private Integer gender;

    @ApiModelProperty("用户账号密码信息（经过加密的）")
    private String userPassword;

    @ApiModelProperty("人员主要联系电话(也可能会使用该信息登录)")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String userName;

    @ApiModelProperty("组织树编码")
    private String code;

}