package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionSelectReqVo", description = "职位下拉框或列表查询")
public class MdmPositionSelectReqVo extends CrmTreeTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("是否当前职位1是0否")
    private String currentFlag;

    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

}