package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "以职位维度的职位及关联用户、组织、上级信息查询请求vo")
public class MdmPositionUserOrgReqVo extends CrmTreeTenVo {

    @ApiModelProperty("职位编码（精确查询这个职位）")
    private String positionCode;

    @ApiModelProperty("职位编码（精确查询这些职位）")
    private List<String> positionCodeList;

    @ApiModelProperty("关联组织编码（查询这个组织直接关联的职位）")
    private String orgCode;

    @ApiModelProperty("组织编码集合（批量查询这些组织直接关联的职位）")
    private List<String> orgCodeList;

    @ApiModelProperty("职位级别编码（查询这个职位级别的职位）")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位 0否 1是 （精确查询）")
    private String primaryFlag;

    @ApiModelProperty("是否当前职位 0否 1是 （精确查询）")
    private String currentFlag;

    @ApiModelProperty("用户登录名（精确查询这个登录名关联的全部职位）")
    private String userName;

    @ApiModelProperty("上级职位编码（精确查询这个职位编码直接关联的职位）")
    private String parentCode;

    @ApiModelProperty("组织编码（查这个组织及全部下级组织的职位）")
    private String allUnderThisOrgCode;

    @ApiModelProperty("组织编码（查这个组织（不含该组织）的全部下级组织的职位）")
    private String allUnderThisOrgCodeExcludeSelf;

    @ApiModelProperty("职位编码（查这个职位的全部下级职位）")
    private String allUnderThisPositionCode;

    @ApiModelProperty("职位编码（查这个职位（不含该职位）的全部下级职位）")
    private String allUnderThisPositionCodeExcludeSelf;

    @ApiModelProperty("用户姓名（模糊查询用户名）")
    private String fullName;

    @ApiModelProperty("职位名称（模糊查询职位名称）")
    private String positionName;

    @ApiModelProperty("组织名称（模糊查询组织名称）")
    private String orgName;

    @ApiModelProperty("模糊查询用户姓名、职位名称、组织名称")
    private String unionNameFuzzyQuery;

    @ApiModelProperty("自定义模糊查询字段1（模糊查询用户登录名，用户姓名）")
    private String unionFuzzyQuery1;
}
