package com.biz.crm.nebular.mdm.position.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位与客户组织关联
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位与客户组织关联")
@SaturnEntity(name = "MdmPositionCustomerOrgRespVo", description = "职位与客户组织关联")
public class MdmPositionCustomerOrgRespVo {

    @ApiModelProperty("id")
    @SaturnColumn(description = "id")
    private String id;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("用户编码")
    @SaturnColumn(description = "用户编码")
    private String userCode;

    @ApiModelProperty("用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

}