package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息列表查询请求VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserPageReqVo", description = "用户信息列表查询请求VO")
public class MdmUserPageReqVo extends CrmExtTenVo {


    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

//    @ApiModelProperty("生效时间")
//    private String startTime;
//
//    @ApiModelProperty("失效时间")
//    private String endTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态")
    private String lockState;

//    @ApiModelProperty("最后一次登录时间")
//    private String lastLoginTime;

    @ApiModelProperty("列表查询条件：公共组织树编码")
    private String code;

    @ApiModelProperty("列表查询条件：上级用户姓名")
    private String parentFullName;

    @ApiModelProperty("列表查询条件：客户编码")
    private String customerCode;

    @ApiModelProperty("列表查询条件：客户名称")
    private String customerName;

    @ApiModelProperty("列表查询条件：角色编码")
    private String roleCode;

    @ApiModelProperty("列表查询条件：职位级别编码")
    private String positionLevelCode;
}