package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户关联客户分页查询响应
 *
 * @author zxw
 * @date 2020-10-12 10:04
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationCustomerPageRespVo", description = "用户关联客户分页查询响应")
@SaturnEntity(name = "MdmUserRelationCustomerPageRespVo", description = "用户关联客户分页查询响应")
public class MdmUserRelationCustomerPageRespVo extends PageVo {

    @ApiModelProperty("渠道")
    @SaturnColumn(description = "渠道")
    private String channel;

    @ApiModelProperty("渠道")
    @SaturnColumn(description = "渠道名称")
    @CrmDict(typeCode = "customer_source",dictCodeField = "channel")
    private String channelName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("客户类型")
    @SaturnColumn(description = "客户类型")
    private String customerType;

    @ApiModelProperty("客户类型")
    @SaturnColumn(description = "客户类型名称")
    @CrmDict(typeCode = "customer_type",dictCodeField = "customerType")
    private String customerTypeName;

    @ApiModelProperty("所属组织名称")
    @SaturnColumn(description = "所属组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @SaturnColumn(description = "职位名称")
    @ApiModelProperty("职位名称")
    private String positionName;
}
