package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalTime;
import java.util.List;

/**
 * 考勤规则明细表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤规则明细表 ")
@SaturnEntity(name = "SfaWorkSignRuleInfoRespVo", description = "考勤规则明细表 ")
public class SfaWorkSignRuleInfoRespVo extends CrmExtVo {
    @ApiModelProperty("人员id 人员id")
    @SaturnColumn(description = "人员id 人员id")
    private String userId;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员名称 人员名称")
    @SaturnColumn(description = "人员名称 人员名称")
    private String realName;

    @ApiModelProperty("职位id 职位id")
    @SaturnColumn(description = "职位id 职位id")
    private String posId;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("组织id 组织id")
    @SaturnColumn(description = "组织id 组织id")
    private String orgId;

    @ApiModelProperty("组织编码 组织编码")
    @SaturnColumn(description = "组织编码 组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称 组织名称")
    @SaturnColumn(description = "组织名称 组织名称")
    private String orgName;

    @ApiModelProperty("规则编码 规则编码")
    @SaturnColumn(description = "规则编码 规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称 规则名称")
    @SaturnColumn(description = "规则名称 规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型 （FREE:自由签到; STATIC:固定时间上下班规则; FREE_TIME:自由时间上下班规则）")
    @SaturnColumn(description = "规则类型（FREE:自由签到; STATIC:固定时间上下班规则; FREE_TIME:自由时间上下班规则）")
    private String ruleType;

    @ApiModelProperty("考勤日期 考勤日期（yyyy-MM-dd）")
    @SaturnColumn(description = "考勤日期 考勤日期（yyyy-MM-dd）")
    private String ruleDate;

    @ApiModelProperty("上班开始时间 上班开始时间(HH:mm:ss)")
    @SaturnColumn(description = "上班开始时间 上班开始时间(HH:mm:ss)")
    private String gotoTime;

    @ApiModelProperty("上班结束时间 上班结束时间(HH:mm:ss)")
    @SaturnColumn(description = "上班结束时间 上班结束时间(HH:mm:ss)")
    private String gooffTime;

    @ApiModelProperty("上班打卡开始时间 上班打卡开始时间(HH:mm:ss)")
    @SaturnColumn(description = "上班打卡开始时间 上班打卡开始时间(HH:mm:ss)")
    private String gotoStartTime;

    @ApiModelProperty("上班打卡结束时间 上班打卡结束时间(HH:mm:ss)")
    @SaturnColumn(description = "上班打卡结束时间 上班打卡结束时间(HH:mm:ss)")
    private String gotoEndTime;

    @ApiModelProperty("下班打卡开始时间 下班打卡开始时间(HH:mm:ss)")
    @SaturnColumn(description = "下班打卡开始时间 下班打卡开始时间(HH:mm:ss)")
    private String gooffStartTime;

    @ApiModelProperty("下班打卡结束时间 下班打卡结束时间(HH:mm:ss)")
    @SaturnColumn(description = "下班打卡结束时间 下班打卡结束时间(HH:mm:ss)")
    private String gooffEndTime;

    @ApiModelProperty("电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)")
    private String electronFence;

    @ApiModelProperty("下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)")
    /**
     * 下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)
     */
    private String gooffWorkSignAstrict;
    /**
     * 拍照打卡;拍照打卡(Y:员工打卡时必须拍照)
     */
    @ApiModelProperty("拍照打卡(Y:员工打卡时必须拍照)")
    @SaturnColumn(description = "拍照打卡(Y:员工打卡时必须拍照)")
    private String wsrPhotograph;
    @ApiModelProperty("考勤打卡记录表 考勤打卡记录表")
    @SaturnColumn(description = "考勤打卡记录表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignRecordRespVo> sfaWorkSignRecordRespVos;



}