package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池条目VO
 * @Author: chenrong
 * @Date: 2020/11/23 16:53
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣费用池条目VO")
public class RebateFeePoolDetailVo extends CrmExtVo {

  private static final long serialVersionUID = -3079031055089868842L;

  /**
   * 折旧费用池编码
   */
  private String rebateFeePoolCode;

  /**
   * 折旧费用池条目code
   */
  private String code;

  /**
   * 支付方式
   */
  private Integer payType;

  /**
   * 条目总金额
   */
  private BigDecimal itemTotalFee = BigDecimal.ZERO;

  /**
   * 条目可用已使用金额
   */
  private BigDecimal itemUsedFee = BigDecimal.ZERO;

  /**
   * 条目冻结金额
   */
  private BigDecimal itemFrozenFee = BigDecimal.ZERO;

  /**
   * 条目可用余额
   */
  private BigDecimal itemAvailableBalance = BigDecimal.ZERO;

  /**
   * 备注
   */
  private String remark;

}
