package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmFileVo;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池VO
 * @Author: chenrong
 * @Date: 2020/11/23 16:53
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣费用池VO")
public class RebateFeePoolVo extends CrmExtVo {

  private static final long serialVersionUID = -8972246479811696975L;

  /**
   * 编码
   */
  private String code;

  /**
   * 客户编码
   */
  private String cusCode;

  /**
   * 客户名称
   */
  private String cusName;

  /**
   * 客户所属组织编码
   */
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  private String cusOrgName;

  /**
   * 销售公司编码
   */
  private String saleCompanyCode;

  /**
   * 销售公司名称
   */
  private String saleCompanyName;

  /**
   * 客户所属渠道编码
   */
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  private String cusChannelName;

  /**
   * 费用池总额
   */
  private BigDecimal totalFee = BigDecimal.ZERO;

  /**
   * 已使用金额
   */
  private BigDecimal usedFee = BigDecimal.ZERO;

  /**
   * 费用池余额
   */
  private BigDecimal balance = BigDecimal.ZERO;

  /**
   * 冻结金额
   */
  private BigDecimal frozenFee = BigDecimal.ZERO;

  /**
   * 折扣费用池唯一约束字典编码
   */
  private String uniqueDictCode;

  /**
   * 支付类型
   */
  private Integer payType;

  /**
   * 折扣费用池条目列表
   */
  private List<RebateFeePoolDetailVo> rebateFeePoolDetailVos;

  /**
   * 冗余字段，扣减金额
   */
  private BigDecimal subtractFee;

  /**
   * 冗余字段，冲销金额
   */
  private BigDecimal redTrickFee;

  /**
   * 冗余字段，来源单号
   */
  private String resourceCode;

  /**
   * 冗余字段，文件对象集合
   */
  private List<CrmFileVo> files;
}
