package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmFileVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池明细VO（产品维度）
 * @Author: chenrong
 * @Date: 2020/11/24 17:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池明细VO（产品维度）")
public class RepFeePoolItemVo extends CrmExtVo {

  /**
   * 货补费用池明细编码
   */
  @ApiModelProperty("货补费用池明细编码")
  private String code;
  /**
   * 货补费用池
   */
  @ApiModelProperty("货补费用池")
  private RepFeePoolVo repFeePoolVo;
  /**
   * 货补费用池编码
   */
  @ApiModelProperty("货补费用池编码")
  private String repFeePoolCode;
  /**
   * 支付类型
   */
  @ApiModelProperty("支付类型")
  private Integer payType;
  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;
  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;
  /**
   * 组合商品数量
   */
  @ApiModelProperty("组合商品数量")
  private Integer productSize = 1;
  /**
   * 成本价格
   */
  @ApiModelProperty("成本价格")
  private BigDecimal costPrice = BigDecimal.ZERO;
  /**
   * 销售价格
   */
  @ApiModelProperty("销售价格")
  private BigDecimal salePrice = BigDecimal.ZERO;
  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String unit;
  /**
   * 上账数量
   */
  @ApiModelProperty("上账数量")
  private BigDecimal onAccountCount = BigDecimal.ZERO;
  /**
   * 已使用数量
   */
  @ApiModelProperty("已使用数量")
  private BigDecimal usedCount = BigDecimal.ZERO;
  /**
   * 冻结数量
   */
  @ApiModelProperty("冻结数量")
  private BigDecimal frozenCount = BigDecimal.ZERO;
  /**
   * 可用数量
   */
  @ApiModelProperty("可用数量")
  private BigDecimal availableCount = BigDecimal.ZERO;
  /**
   * 上账金额
   */
  @ApiModelProperty("上账金额")
  private BigDecimal ouAccountFee = BigDecimal.ZERO;
  /**
   * 已使用金额
   */
  @ApiModelProperty("已使用金额")
  private BigDecimal usedFee = BigDecimal.ZERO;
  /**
   * 冻结金额
   */
  @ApiModelProperty("冻结金额")
  private BigDecimal frozenFee = BigDecimal.ZERO;
  /**
   * 可用金额
   */
  @ApiModelProperty("可用金额")
  private BigDecimal availableFee = BigDecimal.ZERO;
  /**
   * 来源编码
   */
  @ApiModelProperty("来源编码")
  private String resourceCode;
  /**
   * 冗余字段，扣减数量
   */
  @ApiModelProperty("冗余字段，扣减数量")
  private BigDecimal subtractCount = BigDecimal.ZERO;
  /**
   * 冗余字段，冲销数量
   */
  @ApiModelProperty("冗余字段，冲销数量")
  private BigDecimal redTrickCount = BigDecimal.ZERO;

  /**
   * 冗余字段，文件对象集合
   */
  private List<CrmFileVo> files;

}
