package com.biz.crm.nebular.mdm.button;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 按钮表返回vo
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "按钮表")
@SaturnEntity(name = "MdmButtonRespVo", description = "按钮表")
@CrmColumnResolve
public class MdmButtonRespVo extends CrmExtTenVo {

    @ApiModelProperty("菜单编码")
    private String functionCode;

    @ApiModelProperty("按钮编码")
    @SaturnColumn(description = "按钮编码")
    private String buttonCode;

    @ApiModelProperty("按扭名称")
    @SaturnColumn(description = "按钮名称")
    private String buttonName;

    @ApiModelProperty("图标")
    @SaturnColumn(description = "图标")
    private String buttonIcon;

    @ApiModelProperty("是否选中，1：是，0：否")
    private String select;

    @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
    private String buttonType;

    @ApiModelProperty("按钮操作类型")
    private String buttonOperationType;

    @ApiModelProperty("url")
    private String apiUrl;

    @ApiModelProperty("询问语")
    private String ask;

    @ApiModelProperty("按钮排序")
    private Integer buttonOrder;

    @ApiModelProperty("功能编码")
    private String doCode;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    private Boolean visible;

}