package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;


@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EnginePositionUnionQueryRespVo", description = "查询职位关联信息vo")
@SaturnEntity(name = "EnginePositionUnionQueryRespVo", description = "查询职位关联信息vo")
@Deprecated
public class EnginePositionUnionQueryRespVo extends UuidVo {

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("上级职位id")
    @SaturnColumn(description = "上级职位id")
    private String parentPositionId;

    @ApiModelProperty("上级职位编码")
    @SaturnColumn(description = "上级职位编码")
    private String parentPositionCode;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("上级组织名称/职位名称/用户名称")
    @SaturnColumn(description = "上级组织名称/职位名称/用户名称")
    private String parentUnionName;

    @ApiModelProperty("是否主职位,y是n否,数据字典position_primary")
    @SaturnColumn(description = "是否主职位,y是n否,数据字典position_primary")
    private Integer isPrimary;

    @ApiModelProperty("关联角色列表")
    @SaturnColumn(description = "关联角色列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmRoleRespVo> roleList;

}