package com.biz.crm.nebular.mdm.pageconfig;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 下级菜单表返回vo
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "下级菜单表")
@SaturnEntity(name = "MdmFunctionSubRespVo", description = "下级菜单表")
public class MdmFunctionSubRespVo extends CrmExtTenVo {

    @ApiModelProperty("下级菜单编码")
    @SaturnColumn(description = "下级菜单编码")
    private String functionCode;

    @ApiModelProperty("菜单类型")
    private String functionType;

    @ApiModelProperty("下级菜单名称")
    @SaturnColumn(description = "下级菜单名称")
    private String functionName;

    @ApiModelProperty("上级菜单编码")
    @SaturnColumn(description = "上级菜单编码")
    private String parentCode;

    @ApiModelProperty("url")
    private String apiUrl;

}