package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionSelectReqVo", description = "职位下拉框或列表查询")
public class MdmPositionSelectReqVo extends CrmTreeTenVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

    @ApiModelProperty("组织编码（查这个组织及全部下级组织的职位）")
    private String allUnderThisOrgCode;

    @ApiModelProperty("职位编码（查这个职位的全部下级职位）")
    private String allUnderThisPositionCode;

    @ApiModelProperty("职位编码（排除当前职位及下级职位）")
    private String notUnderThisPositionCode;

    private String notUnderPositionRuleCode;
    private String allUnderPositionRuleCode;
    private String allUnderOrgRuleCode;

}