package com.biz.crm.nebular.tpm.advancepay.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动预付明细表 返回vo
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动预付明细表 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmActAdvancePayDetailRespVo", description = "活动预付明细表 ")
public class TpmActAdvancePayDetailRespVo extends CrmExtVo {
    @ApiModelProperty("预付编号")
    @SaturnColumn(description = "预付编号")
    private String advanceCode;

    @ApiModelProperty("预付明细编码")
    @SaturnColumn(description = "预付明细编码")
    private String advanceDetailCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;

    @ApiModelProperty("支付方式(字典编码)")
    @SaturnColumn(description = "支付方式(字典编码)")
    private String payType;

    @ApiModelProperty("支付方式名称")
    @SaturnColumn(description = "支付方式名称")
    private String payTypeName;

    @ApiModelProperty("费用申请金额")
    @SaturnColumn(description = "费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("申请预付金额")
    @SaturnColumn(description = "申请预付金额")
    private BigDecimal applyAdvanceAmount;

    @ApiModelProperty("已申请预付总金额")
    @SaturnColumn(description = "已申请预付总金额")
    private BigDecimal alreadyApplyAdvanceTotalAmount;

    @ApiModelProperty("已预付金额")
    @SaturnColumn(description = "已预付金额")
    private BigDecimal actualAdvancePayMount;

    @ApiModelProperty("预付原因")
    @SaturnColumn(description = "预付原因")
    private String advanceReason;

    @ApiModelProperty("付款方")
    @SaturnColumn(description = "付款方")
    private String payer;

    @ApiModelProperty("付款方账号")
    @SaturnColumn(description = "付款方账号")
    private String payAccount;

    @ApiModelProperty("收款方")
    @SaturnColumn(description = "收款方")
    private String receiver;

    @ApiModelProperty("收款方账号")
    @SaturnColumn(description = "收款方账号")
    private String receiverAccount;

}