package com.biz.crm.nebular.dms.rebatefeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用池报表返回数据对象
 * @Author: chenrong
 * @Date: 2020/11/26 10:34
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("费用池报表返回数据对象")
public class FeePoolFindAccountReportRes implements Serializable {

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty("客户所属组织编码")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty("客户所属组织名称")
  private String cusOrgName;

  /**
   * 项目
   */
  @ApiModelProperty("项目")
  private String projectName;

  /**
   * 期间
   */
  @ApiModelProperty("期间")
  private String period;

  /**
   * 期初余额
   */
  @ApiModelProperty("期初余额")
  private BigDecimal earlyBalance;

  /**
   * 本期上账金额
   */
  @ApiModelProperty("本期上账金额")
  private BigDecimal currentOnAccount;

  /**
   * 本期已使用金额
   */
  @ApiModelProperty("本期已使用金额")
  private BigDecimal currentUsedAccount;

  /**
   * 本期余额
   */
  @ApiModelProperty("本期余额")
  private BigDecimal currentBalance;
}
