package com.biz.crm.nebular.mdm.dict.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据字典类型表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据字典类型表")
public class MdmDictTypeRespVo extends CrmExtTenVo {

    @ApiModelProperty("字典类型编码")
    private String dictTypeCode;

    @ApiModelProperty("字典类型名称")
    private String dictTypeName;

    @ApiModelProperty("字典类型描述")
    private String dictTypeDesc;

    @ApiModelProperty("字典类型所属模块")
    private String dictTypeModule;

    @ApiModelProperty("字典类型所属模块名称 数据字典 dict_type_module")
    @CrmDict(typeCode = "dict_type_module", dictCodeField = "dictTypeModule")
    private String dictTypeModuleName;

}