package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织关联职位")
@SaturnEntity(name = "EngineOrgPositionRespVo", description = "组织关联职位")
@Deprecated
public class EngineOrgPositionRespVo extends UuidVo {

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("上级用户帐号")
    @SaturnColumn(description = "上级用户帐号")
    private String parentUserAccount;

    @ApiModelProperty("上级用户名称")
    @SaturnColumn(description = "上级用户名称")
    private String parentUserName;

    @ApiModelProperty("上级职位编码")
    @SaturnColumn(description = "上级职位编码")
    private String parentPositionCode;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("上级组织编码")
    @SaturnColumn(description = "上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("上级组织名称")
    @SaturnColumn(description = "上级组织名称")
    private String parentOrgName;

}