package com.biz.crm.nebular.mdm.org.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 组织客户关联返回VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织客户关联返回VO")
@CrmColumnResolve
public class MdmOrgCustomerRespVo extends UuidVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("客户类型名称")
    @CrmDict(typeCode = "customer_type", dictCodeField = "customerType")
    private String customerTypeName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("渠道名称")
    @CrmDict(typeCode = "customer_source", dictCodeField = "channel")
    private String channelName;


}