package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 用户-终端关联：关联终端入参
 *
 * @author zxw
 * @date 2020-10-15 14:08
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "MdmUserRelationTerminalReqVo", description = "用户-终端关联：关联终端入参")
public class MdmUserRelationTerminalReqVo {

    @ApiModelProperty("职位编码")
    @NotBlank(message = "职位编码不能为空")
    private String positionCode;

    @ApiModelProperty("终端编码集合")
    @NotEmpty(message = "终端编码集合不能为空")
    private List<String> terminalCodeList;

}
