package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 工作总结 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSummaryReqVo", description = "工作总结 ")
public class SfaWorkSummaryReqVo extends CrmExtVo {


    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String overDate;

    @ApiModelProperty("当前用户")
    private String userCode;

    @ApiModelProperty("总结类型 1日报 2周报 3月报")
    private String summaryType;

    @ApiModelProperty("总结内容")
    private String content;

    @ApiModelProperty("工作计划")
    private String wordPlan;

    @ApiModelProperty("可见范围  0全部 1自己及上级 2所在组织及下级 3自定义")
    private String visibility;

    @ApiModelProperty("自定义人员详情")
    private List<SfaStaffMessageReqVo> sfaStaffMessageReqVos;

    @ApiModelProperty("当前登录人当前职位的下级职位")
    private List<String> subPosition;

    @ApiModelProperty("当前登录人当前职位的上级职位")
    private List<String> supPosition;

    @ApiModelProperty("当前登录人所属的组织编码")
    private String presentOrgCode;

}