package com.biz.crm.nebular.dms.contract;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同主信息的vo")
@SaturnEntity(name = "ContractVo", description = "合同主信息")
@SaturnDomain(value = "contract")
public class ContractVo extends CrmExtVo {

    @SaturnColumn(description = "合同类型")
    private Integer type;

    @ApiModelProperty(value = "合同类型名称")
    @SaturnColumn(description = "合同类型名称")
    @CrmDict(typeCode="contract_type",dictCodeField="type")
    private String typeName;

    @ApiModelProperty(value = "合同年度")
    @SaturnColumn(description = "合同年度")
    private Integer year;

    @ApiModelProperty(value = "合同编号")
    @SaturnColumn(description = "合同编号")
    private String code;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "对接人编码")
    @SaturnColumn(description = "对接人编码")
    private String dockingCode;

    @ApiModelProperty(value = "对接人名称")
    @SaturnColumn(description = "对接人名称")
    private String dockingName;

    @ApiModelProperty(value = "客户法人代表")
    @SaturnColumn(description = "客户法人代表")
    private String legalRepresent;

    @ApiModelProperty(value = "客户联系方式")
    @SaturnColumn(description = "客户联系方式")
    private String cusPhone;

    @ApiModelProperty(value = "渠道类型编码")
    @SaturnColumn(description = "渠道类型编码")
    private String cusChannelCode;

    @ApiModelProperty(value = "渠道类型")
    @SaturnColumn(description = "渠道类型")
    private String cusChannelName;

    @ApiModelProperty(value = "所属组织Code")
    @SaturnColumn(description = "所属组织Code")
    private String cusOrgCode;

    @ApiModelProperty(value = "所属组织名称")
    @SaturnColumn(description = "所属组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "省编码")
    @SaturnColumn(description = "省编码")
    private String provinceCode;

    @ApiModelProperty(value = "省")
    @SaturnColumn(description = "省")
    private String province;

    @ApiModelProperty(value = "市编码")
    @SaturnColumn(description = "市编码")
    private String cityCode;

    @ApiModelProperty(value = "市")
    @SaturnColumn(description = "市")
    private String city;

    @ApiModelProperty(value = "区县编码")
    @SaturnColumn(description = "区县编码")
    private String districtCode;

    @ApiModelProperty(value = "区县")
    @SaturnColumn(description = "区县")
    private String district;

    @ApiModelProperty(value = "合同有效开始时间，格式 yyyy-MM-dd")
    @SaturnColumn(description = "合同有效开始时间，格式 yyyy-MM-dd")
    private String startTime;

    @ApiModelProperty(value = "合同有效截止时间，格式 yyyy-MM-dd")
    @SaturnColumn(description = "合同有效截止时间，格式 yyyy-MM-dd")
    private String endTime;

    @ApiModelProperty(value = "合同展示是否隐藏销售范围标志")
    @SaturnColumn(description = "合同展示是否隐藏销售范围标志")
    private Integer areasHideFlag;

    @ApiModelProperty(value = "销售范围")
    @SaturnColumn(description = "销售范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<ContractSalesAreaVo> salesAreas;

    @ApiModelProperty(value = "文件信息")
    @SaturnColumn(description = "文件信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<ContractFileVo> files;
}
