package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.common.vo.FormInstanceUuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "促销政策编辑页面-促销商品")
@Data
@SaturnEntity(name = "PromotionPolicyProduct", description = "促销政策编辑页面-促销商品")
public class PromotionPolicyProduct extends FormInstanceUuidVo implements Serializable {
    /**
     * 促销商品-本品
     */
    @ApiModelProperty(value = "促销商品-本品")
    @SaturnColumn(description = "促销商品-本品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyProductEditVo> productsCurrentY;
    /**
     * 促销商品-赠品
     */
    @ApiModelProperty(value = "促销商品-赠品")
    @SaturnColumn(description = "促销商品-赠品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyProductEditVo> productsCurrentN;
}
