package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 客户信息：收货地址请求vo
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerAddressReqVo", description = "客户信息：收货地址")
public class MdmCustomerAddressReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("层级等级查询用")
    private Integer levelNum;

    @ApiModelProperty("规则code查询用")
    private String ruleCode;

    @ApiModelProperty("市")
    private String cityCode;

    @ApiModelProperty("区")
    private String districtCode;

    @ApiModelProperty("省")
    private String provinceCode;

    @ApiModelProperty("送达方编码")
    private String destinationCode;

    @ApiModelProperty("送达方名称")
    private String destinationName;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactPhone;

    @ApiModelProperty("是否默认地址，1：是，0：否")
    private String defaultAddress;

}