package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;

/**
 * 组织列表：仅前端使用
 *
 * @author zxw
 * @date 2020-09-30 09:34
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织机构信息列表：仅前端使用")
@SaturnEntity(name = "EngineNebulaOrgRespVo", description = "组织机构信息列表：仅前端使用")
@Deprecated
public class EngineNebulaOrgRespVo {

    @ApiModelProperty(name="code" , value="组织机构唯一编号", required=true)
    @SaturnColumn(description="组织机构的唯一编号")
    private String code;

    @ApiModelProperty(name="orgCode" , value="组织机构唯一编号", required=true)
    @Column(name="org_code" , length=128 , nullable=false , unique = true , columnDefinition = "varchar(128) COMMENT '组织机构唯一编号'")
    @SaturnColumn(description="组织机构的唯一编号")
    private String orgCode;

    @ApiModelProperty(name = "org_name", value = "组织机构名称", required = true)
    @SaturnColumn(description = "组织机构名称")
    private String orgName;

    @ApiModelProperty(name = "type", value = "组织机构类型(0:部门,1:单位)", required = true)
    @SaturnColumn(description = "组织机构类型")
    private Integer type;

    @ApiModelProperty(name = "description", value = "组织机构描述", required = true)
    @SaturnColumn(description = "组织机构描述")
    private String description = "";


}
