package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Set;

/**
 * 用户存储vo
 *
 * @author zxw
 * @date 2020-10-23 14:10
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel("用户存储vo")
@Deprecated
public class EngineUserStoreVo {

    @SaturnColumn(description="人员姓名", length = 64, nullable = false)
    private String userName;

    @SaturnColumn(description="用户账号登录信息", length = 64, nullable = false, unique = true)
    private String account;

    @SaturnColumn(description="身份证号码", length = 64, nullable = true)
    private String idcard;

    @SaturnColumn(description="人员主要联系电话", length = 64, nullable = true, unique = true)
    private String phone = "";

    @SaturnColumn(description="用户账号密码信息", length = 128, nullable = false)
    private String password;

    @SaturnColumn(description="创建时间", nullable = false)
    private Date createTime=new Date();

    @SaturnColumn(description="入职时间", nullable = false)
    private Date entryTime=new Date();

    @SaturnColumn(description="最后一次登录时间", nullable = true)
    private Date lastloginTime=new Date();

    @SaturnColumn(description="用户账号状态", nullable = false)
    private Integer useStatus = 1;

    @SaturnColumn(description="人员头像", length = 64, nullable = false)
    private String userHead = "";

    /**
     * 男1女2
     */
    private Integer gender = 0;

    @SaturnColumn(description="所属组织机构信息" , nullable=true)
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.ManyToMany , master=false , mappedBy="users")
    private Set<EngineOrgStoreVo> orgs;

    @SaturnColumn(description="所属岗位信息")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.ManyToMany , master=false , mappedBy="users")
    private Set<EnginePositionStoreVo> positions;

//    @SaturnColumn(description="分组信息")
//    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.ManyToMany , master=false , mappedBy="users")
//    private Set<UserGroupVo> groups;
    @SaturnColumn(description = "当前使用岗位的id")
    private String mainPosition;
    @SaturnColumn(description = "主组织机构的ID")
    private String mainOrg;

}
