package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户下属")
@SaturnEntity(name = "EngineUserUnderlingRespVo", description = "用户下属")
@Deprecated
public class EngineUserUnderlingRespVo extends UuidVo {

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("下级职位编码")
    @SaturnColumn(description = "下级职位编码")
    private String underlingPositionCode;

    @ApiModelProperty("下级职位名称")
    @SaturnColumn(description = "下级职位名称")
    private String underlingPositionName;

    @ApiModelProperty("下级登录账号")
    @SaturnColumn(description = "下级登录账号")
    private String underlingUserAccount;

    @ApiModelProperty("下级用户姓名")
    @SaturnColumn(description = "下级用户姓名")
    private String underlingUserName;

    @ApiModelProperty("下级组织编码")
    @SaturnColumn(description = "下级组织编码")
    private String underlingOrgCode;

    @ApiModelProperty("下级组织名称")
    @SaturnColumn(description = "下级组织名称")
    private String underlingOrgName;

    @ApiModelProperty("下级职位级别编码")
    @SaturnColumn(description = "下级职位级别编码")
    private String underlingPositionLevelCode;

    @ApiModelProperty("下级职位级别名称")
    @SaturnColumn(description = "下级职位级别名称")
    private String underlingPositionLevelName;

}
