package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据权限返回vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据权限")
@SaturnEntity(name = "MdmDataPermissionRespVo", description = "数据权限")
@CrmColumnResolve
public class MdmDataPermissionRespVo extends CrmTreeVo {
    @ApiModelProperty("角色编码")
    @SaturnColumn(description = "角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @SaturnColumn(description = "角色名称")
    private String roleName;

    @ApiModelProperty("列表配置编码")
    @SaturnColumn(description = "列表配置编码")
    private String listConfigCode;

    @ApiModelProperty("列表名称")
    @SaturnColumn(description = "列表名称")
    private String listConfigName;

    @ApiModelProperty("菜单编码")
    @SaturnColumn(description = "菜单编码")
    private String competenceCode;

    @ApiModelProperty("菜单名称")
    @SaturnColumn(description = "菜单名称")
    private String competenceName;

    @ApiModelProperty("权限对象编码")
    @SaturnColumn(description = "权限对象编码")
    private String permissionObjCode;

    @ApiModelProperty("权限对象名称")
    @SaturnColumn(description = "权限对象名称")
    @CrmDict(typeCode = DictConstant.PERMISSION_OBJ, dictCodeField = "permissionObjCode")
    private String permissionObjName;

    @ApiModelProperty("权限维度，数据字典：permission_dimension")
    @SaturnColumn(description = "权限维度，数据字典：permission_dimension")
    private String permissionDimension;

    @ApiModelProperty("权限维度，数据字典：permission_dimension")
    @SaturnColumn(description = "权限维度，数据字典：permission_dimension")
    @CrmDict(typeCode = DictConstant.PERMISSION_DIMENSION, dictCodeField = "permissionDimension")
    private String permissionDimensionName;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    @SaturnColumn(description = "数据来源，数据字典：permission_resource")
    private String permissionResource;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    @SaturnColumn(description = "数据来源，数据字典：permission_resource")
    @CrmDict(typeCode = DictConstant.PERMISSION_RESOURCE, dictCodeField = "permissionResource")
    private String permissionResourceName;

    @ApiModelProperty("查询方式类型")
    @SaturnColumn(description = "查询方式类型")
    private String permissionSearchType;

    @ApiModelProperty("查询方式名称")
    @SaturnColumn(description = "查询方式名称")
    private String permissionSearchTypeName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

}