package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 工作任务(接收) 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkTaskReceveReqVo", description = "工作任务(接收) ")
public class SfaWorkTaskReceveReqVo extends CrmExtVo {

    @ApiModelProperty("当前id")
    private String receveId;

    @ApiModelProperty("接收人姓名")
    private String receverName;

    @ApiModelProperty("接收人账号")
    private String receverCode;

    @ApiModelProperty("关键字")
    private String keyWord;

    @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
    private String executeStatus;

    @ApiModelProperty("创建时间开始")
    private String startDateOne;

    @ApiModelProperty("创建时间结束")
    private String startDateTwo;

    @ApiModelProperty("截止时间开始")
    private String overDateOne;

    @ApiModelProperty("截止时间结束")
    private String overDateTwo;

    @ApiModelProperty("查询日期 YYYY-MM-dd")
    private String queryDate;

    @ApiModelProperty("执行总结")
    private String summary;

    @ApiModelProperty("执行完成时定位")
    private String address;

    @ApiModelProperty("照片列表")
    private List<SfaWorkTaskPictureReqVo> pictures;


}