package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池条目日志VO
 * @Author: chenrong
 * @Date: 2020/11/25 21:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池条目日志VO")
public class RepFeePoolItemDetailLogVo extends CrmExtVo {

    private static final long serialVersionUID = -5268334565391246884L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 来源编码
     */
    @ApiModelProperty(value = "来源编码")
    private String resourceCode;

    /**
     * 支付类型
     */
    @ApiModelProperty(value = "支付类型")
    private Integer payType;

    /**
     * 货补费用池条目编码
     */
    @ApiModelProperty(value = "货补费用池条目编码")
    private String repFeePoolItemDetailCode;

    /**
     * 调整数量
     */
    @ApiModelProperty(value = "调整数量")
    private BigDecimal adjustCount = BigDecimal.ZERO;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustFee = BigDecimal.ZERO;

    /**
     * 数量调整类型
     */
    @ApiModelProperty(value = "数量调整类型")
    private Integer adjustCountType;

    /**
     * 金额调整类型
     */
    @ApiModelProperty(value = "金额调整类型")
    private Integer adjustFeeType;

    /**
     * 货补费用池日志
     */
    @ApiModelProperty(value = "货补费用池日志")
    private List<RepFeePoolFileVo> files;
}
