package com.biz.crm.nebular.job.resp;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: ScheduleJobReqVo
 * @Description: 定时任务配置入参Vo
 * @Author: Xiao
 * @Date: 2020/09/27
 **/
@Data
@ApiModel(value = "QrtzScheduleJobRespVo", description = "定时任务配置响应")
@SaturnEntity(name = "QrtzScheduleJobRespVo", description = "定时任务配置响应")
public class QrtzScheduleJobRespVo extends PageVo {

    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    @SaturnColumn(description = "任务名称")
    private String jobName;
    /**
     * 任务分组
     */
    @ApiModelProperty("任务分组")
    @SaturnColumn(description = "任务分组")
    private String jobGroup;

    /**
     * 指定执行类
     */
    @ApiModelProperty("指定执行类")
    @SaturnColumn(description = "指定执行类")
    private String jobClass;
    /**
     * cron表达式
     */
    @ApiModelProperty("cron表达式")
    @SaturnColumn(description = "cron表达式")
    private String cronExpression;
}
