package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 用户-客户关联：关联客户入参
 *
 * @author zxw
 * @date 2020-10-09 18:51
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationCustomerReqVo", description = "用户-客户关联：关联客户入参")
public class MdmUserRelationCustomerReqVo {

    @ApiModelProperty("职位编码")
    @NotBlank(message = "职位编码不能为空")
    private String positionCode;

    @ApiModelProperty("客户编码集合")
    @NotEmpty(message = "客户编码集合不能为空")
    private List<String> customerCodeList;
}
