package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户信息表")
@CrmColumnResolve
public class MdmUserRespVo extends CrmExtTenVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("用户类型名称")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("职位列表")
    private List<MdmPositionRespVo> positionList;

    @ApiModelProperty("关联客户列表")
    private List<MdmCustomerMsgRespVo> customerList;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位")
    private String positionName;

    @ApiModelProperty("上级职位编码")
    private String parentPositionCode;

    @ApiModelProperty("上级职位")
    private String parentPositionName;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别")
    private String positionLevelName;

    @ApiModelProperty("上级用户登录名")
    private String parentUserName;

    @ApiModelProperty("上级用户姓名")
    private String parentFullName;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    private String orgName;

    @ApiModelProperty("锁定状态")
    @CrmDict(typeCode = DictConstant.LOCK_STATE,dictCodeField = "lockState")
    private String lockStateName;

    @ApiModelProperty("关联客户编码（客户用户（一对一）时候使用）")
    private String customerCode;

    @ApiModelProperty("关联客户名称（客户用户（一对一）时候使用）")
    private String customerName;

    @ApiModelProperty("角色编码（客户用户（一对一）时候使用）")
    private String roleCode;

    @ApiModelProperty("角色名称（客户用户（一对一）时候使用）")
    private String roleName;

}