package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.common.vo.FormInstanceUuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "促销政策编辑页面-促销范围")
@Data
@SaturnEntity(name = "PromotionPolicyScope", description = "促销政策编辑页面-促销范围")
public class PromotionPolicyScope extends FormInstanceUuidVo implements Serializable {
    /**
     * 促销范围-组织
     */
    @ApiModelProperty(value = "促销范围-组织")
    @SaturnColumn(description = "促销范围-组织")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyScopeGroup scopesAsOrg;
    /**
     * 促销范围-渠道
     */
    @ApiModelProperty(value = "促销范围-渠道")
    @SaturnColumn(description = "促销范围-渠道")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyScopeGroup scopesAsChannel;
    /**
     * 促销范围-客户
     */
    @ApiModelProperty(value = "促销范围-客户")
    @SaturnColumn(description = "促销范围-客户")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyScopeGroup scopesAsCust;
}

