package com.biz.crm.nebular.mdm.terminal;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 11:18 上午
 */
@Data
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmTerminalVo extends CrmTreeVo {
    @ApiModelProperty("门店编码查询条件")
    private List<String> terminalCodeList;
    @ApiModelProperty("左侧组织查询编码")
    private String code;
    @ApiModelProperty("左侧组织查询编码集合")
    private List<String> orgCodeList;
    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    private String terminalCode;
    /**
     * 终端名称
     */
    @ApiModelProperty("终端名称")
    private String terminalName;

    /**
     * 终端类型
     */
    @ApiModelProperty("终端类型")
    private String terminalType;

    /**
     * 所属组织编码
     */
    @ApiModelProperty("所属组织编码")
    private String orgCode;
    @ApiModelProperty("所属组织名字")
    private String orgName;
    /**
     * 客户组织编码
     */
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    /**
     * 渠道
     */
    @ApiModelProperty("渠道")
    private String channel;
    @ApiModelProperty("渠道名字")
    private String channelName;
    /**
     * 营业执照法人姓名
     */
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;

    /**
     * 营业执照注册号
     */
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;

    /**
     * 营业执照企业名称
     */
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;

    /**
     * 终端地址
     */
    @ApiModelProperty("终端地址")
    private String terminalAddress;

    /**
     * 省
     */
    @ApiModelProperty("省编码")
    private String provinceCode;

    /**
     * 市
     */
    @ApiModelProperty("市编码")
    private String cityCode;

    /**
     * 区
     */
    @ApiModelProperty("区编码")
    private String districtCode;

    /**
     * 店招照片
     */
    @ApiModelProperty("店招照片")
    private String shopImagePath;

    /**
     * 营业执照照片
     */
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("联系人信息集合")
    private List<MdmTerminalContactVo> contacts;
    @ApiModelProperty("供货关系集合")
    private List<MdmTerminalSupplyVo> supplys;
}
