package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户下属")
public class MdmUserUnderlingReqVo extends PageVo {

    @ApiModelProperty("下属职位编码集合")
    private List<String> underlingPositionCodeList;

    @ApiModelProperty("用户登录名")
    private String userAccount;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("下级职位编码")
    private String underlingPositionCode;

    @ApiModelProperty("下级职位名称")
    private String underlingPositionName;

    @ApiModelProperty("下级登录账号")
    private String underlingUserName;

    @ApiModelProperty("下级用户姓名")
    private String underlingFullName;

    @ApiModelProperty("下级组织编码")
    private String underlingOrgCode;

    @ApiModelProperty("下级组织名称")
    private String underlingOrgName;

    @ApiModelProperty("下级职位级别编码")
    private String underlingPositionLevelCode;

    @ApiModelProperty("下级职位级别名称")
    private String underlingPositionLevelName;

}
