package com.biz.crm.nebular.sfa.assistant.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作总结 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结 ")
@SaturnEntity(name = "SfaWorkSummaryRespVo", description = "工作总结 ")
public class SfaWorkSummaryRespVo extends CrmExtVo {
    @ApiModelProperty("总结类型")
    private String summaryType;

    @ApiModelProperty("总结内容")
    private String content;

    @ApiModelProperty("工作计划")
    private String wordPlan;

    @ApiModelProperty("返回人员集合")
    private List<SfaWorkSummaryStaffRespVo> staffRespVos;

    @ApiModelProperty("照片")
    private List<SfaWorkTaskPictureRespVo> pictureRespVos;

    @ApiModelProperty("上一个")
    private SfaWorkSummaryStaffRespVo staffRespVoUp;

    @ApiModelProperty("下一个")
    private SfaWorkSummaryStaffRespVo staffRespVoDown;



}