package com.biz.crm.nebular.sfa.calculateSalaryDate.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 计算薪资年 返回vo
 *
 * @author lf
 * @date 2020-11-25 17:04:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "计算薪资年 ")
@SaturnEntity(name = "SfaCalculateSalaryDateRespVo", description = "计算薪资年 ")
public class SfaCalculateSalaryDateRespVo extends CrmExtTenVo {
    @ApiModelProperty("年份")
    @SaturnColumn(description = "年份")
    private String year;

    @ApiModelProperty("日期")
    @SaturnColumn(description = "日期")
    private String date;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    @SaturnColumn(description = "真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("日期信息")
    @SaturnColumn(description = "日期信息")
    private List<SfaCalculateSalaryDateRespVo> dateRespVoList;

    @ApiModelProperty("日期集合")
    private String dateList;

}