package com.biz.crm.nebular.sfa.visitnote.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访计划制定 请求vo
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitPlanReqVo", description = "拜访计划制定 ")
public class SfaVisitPlanReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访计划编码 拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("人员账号 人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名 人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位编码 人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称 人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码 人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称 人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("循环开始日期 循环开始日期yyyy-MM-dd")
    private String visitStartDate;

    @ApiModelProperty("循环结算日期 循环结算日期yyyy-MM-dd")
    private String visitEndDate;

    @ApiModelProperty("排除 排除（星期一、星期二、星期三、星期四、星期五、星期六、星期日）")
    private String notWeekSet;

    @ApiModelProperty("排除描述 排除描述（星期一、星期二、星期三、星期四、星期五、星期六、星期日）")
    private String notWeekSetDesc;

    @ApiModelProperty("拜访类型 拜访类型 （temporary-临时拜访，plan-计划拜访，helpDefense-协访）")
    private String planType;

    @ApiModelProperty("维度类型 维度类型（line-线路组、outlets-网点、rate-频率	）")
    private String routeType;

    @ApiModelProperty("被协访的人员ID 被协访的人员ID")
    private String cvUserId;

    @ApiModelProperty("被协访的人员账号 被协访的人员账号")
    private String cvUserName;

    @ApiModelProperty("被协访的人员姓名 被协访的人员姓名")
    private String cvRealName;

    @ApiModelProperty("被协访的人员职位ID 被协访的人员职位ID")
    private String cvPosId;

    @ApiModelProperty("被协访的人员职位编码 被协访的人员职位编码")
    private String cvPosCode;

    @ApiModelProperty("被协访的人员职位名称 被协访的人员职位名称")
    private String cvPosName;

    @ApiModelProperty("被协访的人员所属组织ID 被协访的人员所属组织ID")
    private String cvOrgId;

    @ApiModelProperty("被协访的人员所属组织编码 被协访的人员所属组织编码")
    private String cvOrgCode;

    @ApiModelProperty("被协访的人员所属组织名称 被协访的人员所属组织名称")
    private String cvOrgName;

    @ApiModelProperty("拜访计划制定范围表 拜访计划制定范围表")
    private List<SfaVisitPlanRangeReqVo> sfaVisitPlanRangeReqVos;

    @ApiModelProperty("线路组id集合")
    private String visitGroupIds;

    @ApiModelProperty("线路组名称集合")
    private String visitGroupNames;

    @ApiModelProperty("拜访计划编码集合 拜访计划编码集合")
    private List<String> visitPlanCodes;

}